<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Subtransaction extends Model 
{

    protected $table = 'subtransactions';
    public $timestamps = true;
    protected $fillable = array('user_id', 'transaction_id', 'description', 'value', 'currency', 'isExpense', 'date');

    public function transaction()
    {
        return $this->belongsTo('App\Models\Transaction', 'transaction_id');
    }

    public function uploads()
    {
        return $this->hasMany('App\Models\SubtransactionUpload', 'subtransaction_id');
    }

}